% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generation.R
\name{Profiles}
\alias{Profiles}
\title{Profiles generation.}
\usage{
Profiles(lvls, coding, c.lvls = NULL)
}
\arguments{
\item{lvls}{A numeric vector which contains for each attribute, the number
of levels.}

\item{coding}{Type op coding that needs to be used for each attribute.}

\item{c.lvls}{A list containing numeric vectors with the attributelevels for
each continuous attribute. The default is \code{NULL}.}
}
\value{
A numeric matrix which contains all possible profiles.
}
\description{
Function to generate all possible combinations of attribute levels (i.e. all
possible profiles).
}
\details{
Valid arguments for \code{coding} are \code{C}, \code{D} and \code{E}. When
using \code{C} the attribute will be treated as continuous and no coding will
be applied. All possible levels should then be specified in \code{c.lvls}. If
\code{D} (dummy coding) is used \code{\link{contr.treatment}} will be applied
to that attribute. For \code{E} (effect coding) \code{\link{contr.sum}} will
be applied.
}
\examples{
# Without continuous attributes
at.lvls <- c(3,4,2) # 3 Attributes with respectively 3, 4 and 2 levels. 
c.type <- rep("E", length(at.lvls)) # All Effect coded.
Profiles(lvls = at.lvls, coding = c.type) # Generate profiles.

# With continuous attributes 
at.lvls <- c(3,4,2) # 3 attributes with respectively 3, 4 and 2 levels. 
# First attribute is dummy coded, second and third are continuous. 
c.type <- c("D", "C", "C") 
# Levels for continuous attributes, in the same order. 
con.lvls <- list(c(4,6,8,10), c(7,9))
Profiles(lvls = at.lvls, coding = c.type, c.lvls = con.lvls)
}
