% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/efficiency_criterions.R
\name{DBerr}
\alias{DBerr}
\title{DB error}
\usage{
DBerr(par.draws, des, n.alts, weights = NULL, mean = TRUE)
}
\arguments{
\item{par.draws}{Numeric matrix in which each row is a draw from a multivariate parameter distribution.}

\item{des}{A design matrix in which each row is an alternative.}

\item{n.alts}{Numeric value indicating the number of alternatives per choice
set.}

\item{weights}{A numeric vector containing weights of \code{par.draws}. The
default is \code{NULL}.}

\item{mean}{A logical value indicating whether the mean (DB) error should be returned or not. Default = TRUE.}
}
\value{
Numeric value indicating the DB-error of the design given the
parameter draws.
}
\description{
Function to calculate the DB-error given a design, and parameter values.
}
\examples{
des <- example_design
mu = c(-1, -1.5, -1, -1.5, 0.5, 1)
Sigma = diag(length(mu))
par.draws <- MASS::mvrnorm(100, mu = mu, Sigma = Sigma)
n.alts = 2
DBerr(par.draws = par.draws, des = des, n.alts = n.alts)

mu = c(-0.5, -1, -0.5, -1, 0.5, 1)
Sigma = diag(length(mu))
par.draws <- MASS::mvrnorm(100, mu = mu, Sigma = Sigma)
DBerr(par.draws = par.draws, des = des, n.alts = n.alts)
}
