% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/idem_visualize.R
\name{plotImputed}
\alias{plotImputed}
\title{Plot density of imputed values}
\usage{
plotImputed(imp.data, lst.var, deltas = 0, endp = FALSE, fname = NULL,
  adj = 1.5, cols = c("red", "cyan", "blue", "green", "brown"),
  ltys = rep(1, 6), xlim = NULL, ylim = NULL, mfrow = NULL, ...)
}
\arguments{
\item{imp.data}{A class \code{IDEM.IMP} dataframe containing complete data
with relevant missing values imputed. See \code{\link{get.imp.all}}.}

\item{lst.var}{see \code{\link{idem-parameters}}}

\item{deltas}{Imputation sensitivity parameter for which to generate the results}

\item{endp}{If TRUE, plot the densities of the imputed functional outcomes.
Otherwise, plot the densities of the imputed outcomes}

\item{fname}{File name of the result pdf file. If \code{fname} is null,
result pdf file will not be generated}

\item{adj}{\code{density} estimation option}

\item{cols}{\code{plot} options}

\item{ltys}{\code{plot} options}

\item{xlim}{\code{plot} options}

\item{ylim}{\code{plot} options}

\item{mfrow}{\code{plot} options}

\item{...}{Options for \code{pdf} function}
}
\description{
Plot density of imputed values and the density of the observed outcomes
}
\examples{
\dontrun{
rst.imp <- get.imp.all(abc, rst.fit, lst.var, deltas=c(-0.25,0,0.25),
                       normal=TRUE, iter=300, n.imp=2, thin=10, p.scale=10);

plotImputed(rst.imp, lst.var, deltas=c(-0.25,0,0.25),
            xlim=c(0,100), endp=FALSE);}

}

