% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AgivenP.R
\encoding{UTF-8}
\name{AgivenP}
\alias{AgivenP}
\alias{AgivenP}
\alias{AP}
\title{Annual value given Present value (Engineering Economics)}
\usage{
AgivenP(P, n, i, frequency = c("annual", "semiannual", "quarter", "bimonth",
  "month", "daily"))

AP(P, n, i, frequency = c("annual", "semiannual", "quarter", "bimonth",
  "month", "daily"))
}
\arguments{
\item{P}{numeric vector that contains the present value(s)}

\item{n}{numeric vector that contains the period value(s)}

\item{i}{numeric vector that contains the interest rate(s) as a percent}

\item{frequency}{character vector that contains the frequency used to
obtain the number of periods [annual (1), semiannual (2), quarter (4),
bimonth (6), month (12), daily (365)]}
}
\value{
AgivenP numeric vector that contains the annual value(s) rounded
   to 2 decimal places

AP data.frame of both n (0 to n) and the resulting annual values
   rounded to 2 decimal places
}
\description{
Compute A given P
}
\details{
A is expressed as

\deqn{A = P\left[\frac{i\left(1 + i\right)^n}{\left(1 + i\right)^n - 1}\right]}

\describe{
\item{\emph{A}}{the "uniform series amount (occurs at the end of each
    interest period)"}
\item{\emph{P}}{the "present equivalent"}
\item{\emph{i}}{the "effective interest rate per interest period"}
\item{\emph{n}}{the "number of interest periods"}
}
}
\examples{
library(iemisc)
# Example for equation 4-14 from the Reference text (page 136)
AgivenP(17000, 4, 1, "annual")
# the interest rate is 1\% per month and n is 4 months

AP(17000, 4, 1, "annual")
# the interest rate is 1\% per month and n is 4 months


# Example 4-30 from the Reference text (page 166)
AgivenP(10000, 5, 12, "month")
# the interest rate is 12\% compounded monthly for 5 years

AP(10000, 5, 12, "month")
# the interest rate is 12\% compounded monthly for 5 years



}
\references{
William G. Sullivan, Elin M. Wicks, and C. Patrick Koelling, \emph{Engineering Economy}, Fourteenth Edition, Upper Saddle River, New Jersey: Pearson/Prentice Hall, 2009, page 136, 142, 164, 166.
}
