#' US DOE/NNSA and DoD Response to 2011 Fukushima Incident: Field Team Radiological Measurements
#'
#' A table containing data after the radiation leaks from the nuclear power
#' plants in Japan.
#'
#'
#'
#' @format A data.table data frame with 4,335 rows and 16 variables:
#' \describe{
#' \item{ID}{Identification}
#' \item{Measurement Date}{Date of measurement}
#' \item{Latitude}{Latitude for the sample location}
#' \item{Longitude}{Longitude for the sample location}
#' \item{Fixed?}{Is the location fixed?}
#' \item{Distance(miles)}{Distance in miles}
#' \item{Bearing}{Bearing for the location}
#' \item{Direction}{Direction for the location}
#' \item{Type}{Type of radiation}
#' \item{Derived?}{Derived radiation value}
#' \item{Value}{Value for the radiation}
#' \item{Unit}{Unit of measurement for radiation value}
#' \item{Source}{Source of data}
#' \item{Description}{Description}
#' \item{Meter}{Name of meter used}
#' \item{Probe}{Name of probe used}
#' }
#'
#'
#' @source
#' United States (US) Department of Energy (DOE)/National Nuclear Security Administration (NNSA), "US DOE/NNSA and DoD Response to 2011 Fukushima Incident: Field Team Radiological Measurements", \url{https://web.archive.org/web/20160617002257/https://catalog.data.gov/dataset/us-doe-nnsa-and-dod-response-to-2011-fukushima-incident-field-team-radiological-measuremen-33914}. Retrieved thanks to the Internet Archive: Wayback Machine
#'
#' 
#'
#'
"Fukushima_2011_FieldMeasurements_5"
#> [1] "Fukushima_2011_FieldMeasurements_5"
