#' US EPA National Primary Drinking Water Regulations Contaminants
#'
#' A table containing the primary drinking water pollutants.
#'
#'
#' @format A data.table data frame with 87 rows and 5 variables:
#' \describe{
#' \item{Contaminant}{The name of the contaminant}
#' \item{MCLG1 (mg/L)2}{Maximum Contaminant Level Goal (MCLG) in mg/L}
#' \item{MCL or TT1 (mg/L)2}{Maximum Contaminant Level (MCL) in mg/L}
#' \item{Potential Health Effects from Long-Term Exposure Above the MCL (unless specified as short-term)}{Potential adverse health effects}
#' \item{Sources of Contaminant in Drinking Water}{What is the source of the contaminant}
#' }
#'
#'
#' @source
#' United States (US) Environmental Protection Agency (EPA): "National Primary Drinking Water Regulations", \url{https://web.archive.org/web/20230801024443/https://www.epa.gov/ground-water-and-drinking-water/national-primary-drinking-water-regulations}. Used the Internet Archive: Wayback Machine archived version for acceptance into CRAN.
#'
#'
#'
#'
"USA_primary_water_contaminants"
#> [1] "USA_primary_water_contaminants"
