/* @(#) Copyright (c), 1988, 2006 Insightful Corp.  All rights reserved. */
static char whatssi[] = "@(#) $File: //depot/Research/ifultools/src/RS_math_acvs.c $: $Revision: #1 $, $Date: 2007/06/26 $ ";

/* This is a self-documenting doc++ file. */

/* This file contains wrapper functions, callable from R
   for the MUTILS math library.

   Functions wrapped:

   mthuniv_acvs()
*/

#include "mth_var.h"
#include "ut_RS.h"
#include "mat_set.h"
#include "mat_umat.h"
#include "mat_univ.h"
#include "ut_debug.h"
#include "ut_intrn.h"
#include "ut_mem.h"
#include "RS_mac.h"

/** One-sided autocovariance.
 * @source R\_mth\_var.c
 * @author Copyright (c), 1988, 2006 Insightful Corp.  All rights reserved.
 * @usage #.Call( "RS_math_acvs", time.series, biased, recenter))#
 * @return             An R ... containing ...
 * @param time.series  Pointer to an R object containing ... time.series
 * @param biased       Pointer to an R object containing ... biased
 * @param recenter     Pointer to an R object containing ... recenter
 * @see fra_spectral_density_function_direct
*/
EXTERN_R SEXP RS_math_acvs(
 SEXP pr_time_series,
 SEXP pr_biased,
 SEXP pr_recenter )
{
  SEXP             pr_ret_result;
  boolean          biased;
  boolean          recenter;
  mutil_data_type  type;
  mutil_errcode    err;
  univ_mat         result;
  univ_mat         time_series;
  void             *VPNULL = NULL;
  memlist          list;

  /* Avoid lint warning */
  (void) whatssi;

  /* initialize memory list */
  MEMLIST_INIT( list );

  /* Conversion of input data ... */

  /* ... pr_time_series to time_series */
  READ_MATRIX_REGISTER( pr_time_series, &time_series );

  /* ... pr_biased to biased */
  BOOLEAN_FROM_R( pr_biased, &biased );

  /* ... pr_recenter to recenter */
  BOOLEAN_FROM_R( pr_recenter, &recenter );

  /* Call the function */
  err = mthuniv_acvs(
    &time_series,
    biased,
    recenter,
    VPNULL,
    &result );
  CONVERT_MATRIX_AND_RETURN( mthuniv_acvs, &result, &pr_ret_result );
}

