% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parallel_mosaic.R
\name{parallel_mosaic}
\alias{parallel_mosaic}
\title{Mosaic from gapfilled objects}
\usage{
parallel_mosaic(
  inputDirImages,
  inputDirRData,
  inputDirMaster,
  outputDir,
  progressReportDir,
  numCores,
  scaleFactor = 10000,
  dataType = "INT4S"
)
}
\arguments{
\item{inputDirImages}{character. Full path name of directory containing files to be 
gap-filled.}

\item{inputDirRData}{character. Full path name of directory containing \code{RData} files 
obtained as the result of using \code{\link[gapfill]{Gapfill}}.
See \bold{Note}.}

\item{inputDirMaster}{character. Full path name of directory containing splits of a
\emph{master} file. See \bold{Details}.}

\item{outputDir}{character. Full path name of directory where output will be saved.
See \bold{Note}.}

\item{progressReportDir}{character. Full path name of directory where a file reporting on the
See \bold{Note}.}

\item{numCores}{numeric. How many cores should be employed in parallel computing?}

\item{scaleFactor}{integer. Default is \code{1e4}. See \bold{Note}.}

\item{dataType}{character. See \code{\link[raster]{writeRaster}} for further details.
Default is \code{INT4S}. See \bold{Note}.}
}
\value{
At \code{outputDir} the user will find \code{n} \emph{Gtiff}
files, where \code{n} is equal to the number of files in \code{inputDirImages}.
}
\description{
Rasterizes the output of \code{\link[igapfill]{applyGapfill}} and
the resulting raster objects are glued together in the manner of a mosaic.
}
\details{
This function may be useful when employing \code{\link[gapfill]{Gapfill}}
independently of the current package.

The term \emph{master} refers to a raster with no missing values
and whose coordinate reference system is used to rasterize objects such as matrices.
}
\note{
Within the workflow of this package, \code{inputDirRData},
\code{inputDirMaster}, \code{outputDir} and \code{progressReportDir} must be equal to the sub-directories 
\emph{/output}, \emph{/master}, \emph{/filled}, and \emph{/progressReports}, respectively. These
folders can be created by \code{\link[igapfill]{create_dirs}}. Many satellite products
come with a scale factor of \code{1e4} and are distributed in formats equivalent to \code{INT4S}.
After \code{\link[igapfill]{applyGapfill}} the objects to rasterize/mosaic must be scaled back,
therefore the default values for arguments \code{scaleFactor} and \code{dataType}.
}
\seealso{
\code{\link[raster]{mosaic}}, \code{\link[igapfill]{applyGapfill}}.
}
