% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grade_hypo.R
\name{grade_hypo}
\alias{grade_hypo}
\title{Percentage of GRADE score attributable to hypoglycemia}
\usage{
grade_hypo(data, lower = 80)
}
\arguments{
\item{data}{DataFrame object with column names "id", "time", and "gl",
or numeric vector of glucose values.}

\item{lower}{Lower bound used for hypoglycemia cutoff, in mg/dL. Default is 80}
}
\value{
If a data.frame object is passed, then a tibble object with
two columns: subject id and corresponding \%GRADE hypoglycemia value is returned. If a vector of glucose
values is passed, then a tibble object with just the \%GRADE hypoglycemia value is returned.
as.numeric() can be wrapped around the latter to output just a numeric value.


}
\description{
The function grade_hypo produces \%GRADE hypoglycemia values in a tibble object.
}
\details{
A tibble object with 1 row for each subject, a column for subject id and
a column for \%GRADE hypoglycemia values is returned. NA glucose values are
omitted from the calculation of the \%GRADE hypoglycemia values.

\%GRADE hypoglycemia is determined by calculating the percentage of
GRADE score (see grade function) attributed to hypoglycemic glucose values.
}
\examples{

data(example_data_1_subject)
grade_hypo(example_data_1_subject)
grade_hypo(example_data_1_subject, lower = 70)

data(example_data_5_subject)
grade_hypo(example_data_5_subject)
grade_hypo(example_data_5_subject, lower = 65)

}
\references{
Hill et al. (2007): A method for assessing quality of control
from glucose profiles
\emph{Diabetic Medicine} \strong{24} .753-758,
\doi{10.1111/j.1464-5491.2007.02119.x}.
}
