% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/epicalc_profile.R
\name{epicalc_profile}
\alias{epicalc_profile}
\title{Display Episode Calculation statistics for selected subject}
\usage{
epicalc_profile(
  data,
  lv1_hypo = 100,
  lv2_hypo = 70,
  lv1_hyper = 120,
  lv2_hyper = 160,
  color_scheme = "Color Scheme 1"
)
}
\arguments{
\item{data}{DataFrame object with column names "id", "time", and "gl"}

\item{lv1_hypo}{A double specifying a hypoglycemia threshold for level 1}

\item{lv2_hypo}{A double specifying a hypoglycemia threshold for level 2}

\item{lv1_hyper}{A double specifying a hyperglycemia threshold for level 1}

\item{lv2_hyper}{A double specifying a hyperglycemia threshold for level 2}

\item{color_scheme}{String corresponding to the chosen color scheme. Acceptable choices are: "Color Scheme 1", "Color Scheme 2", and
"Color Scheme 3". Color Scheme 1 is orange/green/red. Color Scheme 2 is red/white/blue. Color Scheme 3 is orange/green/red.}
}
\value{
A plot displaying the varying glucose levels (mg/dL) of the subject in a day as well as the statistics for the episodes.
}
\description{
Display Episode Calculation statistics for selected subject
}
\examples{
epicalc_profile(example_data_1_subject)

}
\author{
Johnathan Shih, Jung Hoon Seo
}
