% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/range_glu.R
\name{range_glu}
\alias{range_glu}
\title{Calculate glucose level range}
\usage{
range_glu(data)
}
\arguments{
\item{data}{DataFrame object with column names "id", "time", and "gl",
or numeric vector of glucose values.}
}
\value{
If a data.frame object is passed, then a tibble object with
two columns: subject id and corresponding range value is returned. If a vector of glucose
values is passed, then a tibble object with just the range value is returned.
as.numeric() can be wrapped around the latter to output just a numeric value.
}
\description{
The function range_glu outputs the distance between minimum
and maximum glucose values per subject in a tibble object.
}
\details{
A tibble object with 1 row for each subject, a column for subject id and
a column for the range values is returned. NA glucose values are
omitted from the calculation of the range.
}
\examples{
data(example_data_1_subject)
range_glu(example_data_1_subject)

data(example_data_5_subject)
range_glu(example_data_5_subject)

}
