% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mage_ma_single.R
\name{mage_ma_single}
\alias{mage_ma_single}
\title{Calculates Mean Amplitude of Glycemic Excursions (see "mage")}
\usage{
mage_ma_single(
  data,
  short_ma = 5,
  long_ma = 32,
  type = c("auto", "plus", "minus"),
  plot = FALSE,
  dt0 = NULL,
  inter_gap = 45,
  tz = "",
  title = NA,
  xlab = NA,
  ylab = NA,
  show_ma = FALSE
)
}
\arguments{
\item{data}{DataFrame object with column names "id", "time", and "gl". Should only be data for 1 subject. In case multiple subject ids are detected, the warning is produced and only 1st subject is used.}

\item{short_ma}{Integer for period length of the short moving average. Must be positive and less than "long_ma", default value is 5. (Recommended <15)}

\item{long_ma}{Integer for period length for the long moving average, default value is 32. (Recommended >20)}

\item{type}{One of "plus", "minus", "auto" (Default: auto). Algorithm will either calculate MAGE+ (nadir to peak), MAGE- (peak to nadir), or automatically choose based on the first countable excursion.}

\item{plot}{Boolean. Returns ggplot if TRUE.}

\item{dt0}{The time frequency for interpolation in minutes, the default will match the CGM meter's frequency (e.g. 5 min for Dexcom).}

\item{inter_gap}{The maximum allowable gap (in minutes) for interpolation. The values will not be interpolated between the glucose measurements that are more than inter_gap minutes apart. The default value is 45 min.}

\item{tz}{A character string specifying the time zone to be used. System-specific (see \code{\link{as.POSIXct}}), but " " is the current time zone, and "GMT" is UTC (Universal Time, Coordinated). Invalid values are most commonly treated as UTC, on some platforms with a warning.}

\item{title}{Title for the ggplot. Defaults to "Glucose Trace - Subject [ID]"}

\item{xlab}{Label for x-axis of ggplot. Defaults to "Time"}

\item{ylab}{Label for y-axis of ggplot. Defaults to "Glucose Level"}

\item{show_ma}{Whether to show the moving average lines on the plot or not}
}
\value{
The numeric MAGE value for the inputted glucose values or a ggplot if \code{plot = TRUE}
}
\description{
This function is an internal function used by "mage". The function will calculate the Mean Amplitude of Glycemic Excursions (MAGE) on \strong{all} the values of the inputted data set. To calculate separate MAGE values for a group of subjects, use the "mage" function.
}
\details{
See "mage".
}
\examples{
data(example_data_1_subject)
mage_ma_single(
   example_data_1_subject,
   short_ma = 4,
   long_ma = 24,
   type = 'plus')

mage_ma_single(
   example_data_1_subject,
   inter_gap = 300)

mage_ma_single(
   example_data_1_subject,
   plot=TRUE,
   title="Patient X",
   xlab="Time",
   ylab="Glucose Level (mg/dL)",
   show_ma=FALSE)
}
\author{
Nathaniel Fernandes
}
