% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meal_metrics.R
\name{meal_metrics}
\alias{meal_metrics}
\title{Calculate Meal Metrics}
\usage{
meal_metrics(data, mealtimes, before_win = 1, after_win = 3,
recovery_win = 1, interpolate = TRUE, adjust_mealtimes = TRUE, dt0 = NULL,
inter_gap = 45, tz = "")
}
\arguments{
\item{data}{DataFrame object with column names "id", "time", and "gl". Should only be data for 1 subject. In case multiple subject ids are detected, a warning is produced and only 1st subject is used.}

\item{mealtimes}{Either a vector of mealtimes, corresponding
to data being from a single subject, OR a dataframe with at least 2 columns labeled
id and mealtime. Optionally the mealtimes dataframe can include a column labeled meal,
giving the meal type (helps to compensate for overlapping meals)}

\item{before_win}{integer specifying number of hours to extend window before meal}

\item{after_win}{integer specifying number of hours to extend window after meal}

\item{recovery_win}{interger specifying number of hours for recovery beyond after window}

\item{interpolate}{Boolean to indicate if CGM data should be interpolated or not.
Default set to FALSE due to time intensive nature of interpolation. Parameters dt0,
inter_gap, and tz will only be used if interpolate is set to TRUE.}

\item{adjust_mealtimes}{Boolean to indicate if function should attempt to align
mealtimes with CGM data times. This is important if mealtimes and CGM data times
are not exactly aligned, because the function will return NA's for mealtimes
that don't match with a corresponding CGM time stamp.}

\item{dt0}{The time frequency for interpolation in minutes, the default will match the CGM meter's frequency (e.g. 5 min for Dexcom).}

\item{inter_gap}{The maximum allowable gap (in minutes) for interpolation. The values will not be interpolated between the glucose measurements that are more than inter_gap minutes apart. The default value is 45 min.}

\item{tz}{A character string specifying the time zone to be used. System-specific (see \code{\link{as.POSIXct}}), but " " is the current time zone, and "GMT" is UTC (Universal Time, Coordinated). Invalid values are most commonly treated as UTC, on some platforms with a warning.}
}
\value{
A tibble object with 6 columns will be returned: id, time, meal, deltag,
deltat, and basereco.
}
\description{
The function meal_metrics calculates three simple glucose meal metrics
}
\details{
A tibble object is returned with three metrics calculated for each mealtime.
The last three columns of the output correspond to the three metrics: deltag
refers to \eqn{\Delta G}, deltat is \eqn{\Delta T}, and basereco is \% Baseline recovery.
If no meal column is given in the original data, one will be automatically generated
with a unique number for each meal.
}
\examples{
data(example_data_hall)
data(example_meals_hall)
meal_metrics(example_data_hall, example_meals_hall)
meal_metrics(example_data_hall, example_meals_hall)

}
\references{
Service, F. John. (2013) Glucose Variability, \emph{Diabetes}
\strong{62(5)}: 1398-1404, \doi{10.2337/db12-1396}
}
