% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layout.R
\name{layout_randomly}
\alias{layout_randomly}
\alias{randomly}
\title{Randomly place vertices on a plane or in 3d space}
\usage{
layout_randomly(graph, dim = 2)

randomly(...)
}
\arguments{
\item{graph}{The input graph.}

\item{dim}{Integer scalar, the dimension of the space to use. It must be 2
or 3.}

\item{...}{Parameters to pass to \code{layout_randomly}.}
}
\value{
A numeric matrix with two or three columns.
}
\description{
This function uniformly randomly places the vertices of the graph in two or
three dimensions.
}
\details{
Randomly places vertices on a [-1,1] square (in 2d) or in a cube (in 3d). It
is probably a useless layout, but it can use as a starting point for other
layout generators.
}
\seealso{
Other graph layouts: \code{\link{add_layout_}},
  \code{\link{component_wise}},
  \code{\link{layout_as_bipartite}},
  \code{\link{layout_as_star}},
  \code{\link{layout_as_tree}},
  \code{\link{layout_in_circle}},
  \code{\link{layout_nicely}},
  \code{\link{layout_on_grid}},
  \code{\link{layout_on_sphere}},
  \code{\link{layout_with_dh}},
  \code{\link{layout_with_fr}},
  \code{\link{layout_with_gem}},
  \code{\link{layout_with_graphopt}},
  \code{\link{layout_with_kk}},
  \code{\link{layout_with_lgl}},
  \code{\link{layout_with_mds}},
  \code{\link{layout_with_sugiyama}},
  \code{\link{layout_}}, \code{\link{merge_coords}},
  \code{\link{norm_coords}}, \code{\link{normalize}}
}
\author{
Gabor Csardi \email{csardi.gabor@gmail.com}
}
\keyword{graphs}
