% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/community.R
\name{cluster_label_prop}
\alias{cluster_label_prop}
\alias{label.propagation.community}
\title{Finding communities based on propagating labels}
\usage{
cluster_label_prop(graph, weights = NULL, initial = NULL, fixed = NULL)
}
\arguments{
\item{graph}{The input graph, should be undirected to make sense.}

\item{weights}{The weights of the edges. It must be a positive numeric vector,
\code{NULL} or \code{NA}. If it is \code{NULL} and the input graph has a
\sQuote{weight} edge attribute, then that attribute will be used. If
\code{NULL} and no such attribute is present, then the edges will have equal
weights. Set this to \code{NA} if the graph was a \sQuote{weight} edge
attribute, but you don't want to use it for community detection. A larger
edge weight means a stronger connection for this function.}

\item{initial}{The initial state. If \code{NULL}, every vertex will have a
different label at the beginning. Otherwise it must be a vector with an
entry for each vertex. Non-negative values denote different labels, negative
entries denote vertices without labels.}

\item{fixed}{Logical vector denoting which labels are fixed. Of course this
makes sense only if you provided an initial state, otherwise this element
will be ignored. Also note that vertices without labels cannot be fixed.}
}
\value{
\code{cluster_label_prop()} returns a
\code{\link[=communities]{communities()}} object, please see the \code{\link[=communities]{communities()}}
manual page for details.
}
\description{
This is a fast, nearly linear time algorithm for detecting community
structure in networks. In works by labeling the vertices with unique labels
and then updating the labels by majority voting in the neighborhood of the
vertex.
}
\details{
This function implements the community detection method described in:
Raghavan, U.N. and Albert, R. and Kumara, S.: Near linear time algorithm to
detect community structures in large-scale networks. Phys Rev E 76, 036106.
(2007). This version extends the original method by the ability to take edge
weights into consideration and also by allowing some labels to be fixed.

From the abstract of the paper: \dQuote{In our algorithm every node is
initialized with a unique label and at every step each node adopts the label
that most of its neighbors currently have. In this iterative process densely
connected groups of nodes form a consensus on a unique label to form
communities.}
}
\examples{

g <- sample_gnp(10, 5 / 10) \%du\% sample_gnp(9, 5 / 9)
g <- add_edges(g, c(1, 12))
cluster_label_prop(g)

}
\references{
Raghavan, U.N. and Albert, R. and Kumara, S.: Near linear time
algorithm to detect community structures in large-scale networks. \emph{Phys
Rev E} 76, 036106. (2007)
}
\seealso{
\code{\link[=communities]{communities()}} for extracting the actual results.

\code{\link[=cluster_fast_greedy]{cluster_fast_greedy()}}, \code{\link[=cluster_walktrap]{cluster_walktrap()}},
\code{\link[=cluster_spinglass]{cluster_spinglass()}}, \code{\link[=cluster_louvain]{cluster_louvain()}} and
\code{\link[=cluster_leiden]{cluster_leiden()}} for other community detection methods.

Other community: 
\code{\link{as_membership}()},
\code{\link{cluster_edge_betweenness}()},
\code{\link{cluster_fast_greedy}()},
\code{\link{cluster_fluid_communities}()},
\code{\link{cluster_infomap}()},
\code{\link{cluster_leading_eigen}()},
\code{\link{cluster_leiden}()},
\code{\link{cluster_louvain}()},
\code{\link{cluster_optimal}()},
\code{\link{cluster_spinglass}()},
\code{\link{cluster_walktrap}()},
\code{\link{compare}()},
\code{\link{contract}()},
\code{\link{groups}()},
\code{\link{make_clusters}()},
\code{\link{membership}()},
\code{\link{modularity.igraph}()},
\code{\link{plot_dendrogram}()},
\code{\link{split_join_distance}()}
}
\author{
Tamas Nepusz \email{ntamas@gmail.com} for the C implementation,
Gabor Csardi \email{csardi.gabor@gmail.com} for this manual page.
}
\concept{community}
\keyword{graphs}
