% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/attributes.R
\name{edge_attr}
\alias{edge_attr}
\alias{get.edge.attribute}
\alias{edge.attributes}
\title{Query edge attributes of a graph}
\usage{
edge_attr(graph, name, index = E(graph))
}
\arguments{
\item{graph}{The graph}

\item{name}{The name of the attribute to query. If missing, then
all edge attributes are returned in a list.}

\item{index}{An optional edge sequence to query edge attributes
for a subset of edges.}
}
\value{
The value of the edge attribute, or the list of all
edge attributes if \code{name} is missing.
}
\description{
Query edge attributes of a graph
}
\examples{
g <- make_ring(10) \%>\%
  set_edge_attr("weight", value = 1:10) \%>\%
  set_edge_attr("color", value = "red")
g
plot(g, edge.width = E(g)$weight)
}
\seealso{
Other graph attributes: 
\code{\link{delete_edge_attr}()},
\code{\link{delete_graph_attr}()},
\code{\link{delete_vertex_attr}()},
\code{\link{edge_attr<-}()},
\code{\link{edge_attr_names}()},
\code{\link{graph_attr<-}()},
\code{\link{graph_attr_names}()},
\code{\link{graph_attr}()},
\code{\link{igraph-dollar}},
\code{\link{igraph-vs-attributes}},
\code{\link{set_edge_attr}()},
\code{\link{set_graph_attr}()},
\code{\link{set_vertex_attr}()},
\code{\link{vertex_attr<-}()},
\code{\link{vertex_attr_names}()},
\code{\link{vertex_attr}()}
}
\concept{graph attributes}
