% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/topology.R
\name{subgraph_isomorphisms}
\alias{subgraph_isomorphisms}
\alias{graph.get.subisomorphisms.vf2}
\title{All isomorphic mappings between a graph and subgraphs of another graph}
\usage{
subgraph_isomorphisms(pattern, target, method = c("lad", "vf2"), ...)
}
\arguments{
\item{pattern}{The smaller graph, it might be directed or
undirected. Undirected graphs are treated as directed graphs with
mutual edges.}

\item{target}{The bigger graph, it might be directed or
undirected. Undirected graphs are treated as directed graphs with
mutual edges.}

\item{method}{The method to use. Possible values: \sQuote{auto},
\sQuote{lad}, \sQuote{vf2}. See their details below.}

\item{...}{Additional arguments, passed to the various methods.}
}
\value{
A list of vertex sequences, corresponding to all
mappings from the first graph to the second.
}
\description{
All isomorphic mappings between a graph and subgraphs of another graph
}
\section{\sQuote{lad} method}{

This is the LAD algorithm by Solnon, see the reference below. It has
the following extra arguments:
\describe{
\item{domains}{If not \code{NULL}, then it specifies matching
restrictions. It must be a list of \code{target} vertex sets, given
as numeric vertex ids or symbolic vertex names. The length of the
list must be \code{vcount(pattern)} and for each vertex in
\code{pattern} it gives the allowed matching vertices in
\code{target}. Defaults to \code{NULL}.}
\item{induced}{Logical scalar, whether to search for an induced
subgraph. It is \code{FALSE} by default.}
\item{time.limit}{The processor time limit for the computation, in
seconds. It defaults to \code{Inf}, which means no limit.}
}
}

\section{\sQuote{vf2} method}{

This method uses the VF2 algorithm by Cordella, Foggia et al., see
references below. It supports vertex and edge colors and have the
following extra arguments:
\describe{
\item{vertex.color1, vertex.color2}{Optional integer vectors giving the
colors of the vertices for colored graph isomorphism. If they
are not given, but the graph has a \dQuote{color} vertex attribute,
then it will be used. If you want to ignore these attributes, then
supply \code{NULL} for both of these arguments. See also examples
below.}
\item{edge.color1, edge.color2}{Optional integer vectors giving the
colors of the edges for edge-colored (sub)graph isomorphism. If they
are not given, but the graph has a \dQuote{color} edge attribute,
then it will be used. If you want to ignore these attributes, then
supply \code{NULL} for both of these arguments.}
}
}

\seealso{
Other graph isomorphism: 
\code{\link{count_isomorphisms}()},
\code{\link{count_subgraph_isomorphisms}()},
\code{\link{graph_from_isomorphism_class}()},
\code{\link{isomorphic}()},
\code{\link{isomorphism_class}()},
\code{\link{isomorphisms}()},
\code{\link{subgraph_isomorphic}()}
}
\concept{graph isomorphism}
