% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/to_widget.R
\name{save_iheatmap}
\alias{save_iheatmap}
\alias{save_iheatmap,Iheatmap,character-method}
\title{save_iheatmap}
\usage{
\S4method{save_iheatmap}{Iheatmap,character}(p, filename, ...)
}
\arguments{
\item{p}{\code{link{Iheatmap-class}} object}

\item{filename}{name of file}

\item{...}{additional arguments to \code{\link[htmlwidgets]{saveWidget}} for
saving as html or \code{\link[webshot]{webshot}} for saving as pdf/png/jpeg}
}
\description{
save an \code{link{Iheatmap-class}} object, either as standalone HTML or as static
pdf/png/jpeg
}
\details{
Note that this function requires the webshot package. If deploying
a shiny app that calls this function in shinyapps.io, loading the webshot
library and calling \code{webshot::install_phantomjs()} is needed for the the save
functionality to work.
}
\examples{
mat <- matrix(rnorm(24), nrow = 6)
hm <- iheatmap(mat)
\dontrun{
save_iheatmap(hm, "example_iheatmap.png")
}
}
\author{
Alicia Schep
}
