% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/axis_labels.R
\name{add_row_labels}
\alias{add_row_labels}
\alias{add_row_labels,Iheatmap-method}
\title{add_row_labels}
\usage{
\S4method{add_row_labels}{Iheatmap}(
  p,
  tickvals = NULL,
  ticktext = NULL,
  textangle = 0,
  font = get_layout(p)$font,
  side = c("left", "right"),
  size = 0.1,
  buffer = 0.005,
  xname = NULL,
  yname = current_yaxis(p)
)
}
\arguments{
\item{p}{\code{\link{Iheatmap-class}} object}

\item{tickvals}{row indices at which to place axis tick labels}

\item{ticktext}{text for axis tick labels}

\item{textangle}{angle for ticktext}

\item{font}{list of plotly font attributes, see 
\url{https://plotly.com/javascript/reference/#layout-font}}

\item{side}{side of plot on which to add subplot}

\item{size}{relative size of subplot relative to main heatmap}

\item{buffer}{amount of space to leave empty before this plot, relative to 
size of first heatmap}

\item{xname}{internal name for xaxis}

\item{yname}{internal name for yaxis}
}
\value{
\code{\link{Iheatmap-class}} object, which can be printed to 
generate an interactive graphic
}
\description{
Add y axis labels to plot
}
\examples{

mat <- matrix(rnorm(20), ncol = 5, nrow = 4)  
hm1 <- iheatmap(mat) \%>\% add_row_labels()
hm2 <- iheatmap(mat) \%>\% add_row_labels(ticktext = letters[23:26])


# Print heatmaps if interactive session 
if (interactive()) hm1
if (interactive()) hm2 
}
\seealso{
\code{\link{add_row_title}}, \code{\link{iheatmap}}, 
\code{\link{add_col_labels}}
}
\author{
Alicia Schep
}
