% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/textlinedetector.R
\name{image_textlines_flor}
\alias{image_textlines_flor}
\title{Text Line Segmentation based on valley finding in projection profiles}
\usage{
image_textlines_flor(
  x,
  light = TRUE,
  type = c("none", "niblack", "sauvola", "wolf")
)
}
\arguments{
\item{x}{an object of class magick-image}

\item{light}{logical indicating to remove light effects due to scanning}

\item{type}{which type of binarisation to perform before doing line segmentation}
}
\value{
a list with elements
\itemize{
\item{n: the number of lines found}
\item{overview: an opencv-image of the detected areas}
\item{textlines: a list of opencv-image's, one for each text line area}
}
}
\description{
Text Line Segmentation based on valley finding in projection profiles
}
\examples{
\donttest{
library(opencv)
library(magick)
library(image.textlinedetector)
path   <- system.file(package = "image.textlinedetector", "extdata", "example.png")
img    <- image_read(path)
img    <- image_resize(img, "1000x")
areas  <- image_textlines_flor(img, light = TRUE, type = "sauvola")
areas  <- lines(areas, img)
areas$n
areas$overview
combined <- lapply(areas$textlines, FUN=function(x) image_read(ocv_bitmap(x)))
combined <- do.call(c, combined)
combined
image_append(combined, stack = TRUE)
}
}
