% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/im.classify.R
\name{im.classify}
\alias{im.classify}
\title{Classify a Raster Image Using K-Means Clustering}
\usage{
im.classify(
  input_image,
  num_clusters = 3,
  seed = NULL,
  do_plot = TRUE,
  custom_colors = NULL,
  num_colors = 100
)
}
\arguments{
\item{input_image}{A `SpatRaster` object representing the input raster image.}

\item{num_clusters}{An integer specifying the number of clusters (default: 3).}

\item{seed}{An optional integer seed for reproducibility of k-means clustering results (default: NULL).}

\item{do_plot}{A logical value indicating whether to display the classified raster (default: TRUE).}

\item{custom_colors}{A vector of custom colors to be used for classification visualization (default: NULL).
If NULL, a predefined set of colors is used.}

\item{num_colors}{The number of colors to interpolate in the visualization palette (default: 100).}
}
\value{
A `SpatRaster` object with cluster assignments.
}
\description{
This function performs unsupervised classification on a raster image using k-means clustering.
It rescales the pixel values to 0–255 to improve visual clustering of scientific TIFFs.
}
