% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/imglist.R
\name{map_il}
\alias{map_il}
\title{Type-stable map for use with the purrr package}
\usage{
map_il(...)
}
\arguments{
\item{...}{passed to map}
}
\value{
an image list
}
\description{
Works like purrr::map, purrr::map_dbl and the like but ensures that the output is an image list.
}
\examples{
#Returns a list
imsplit(boats,"x",2) \%>\% purrr::map(~ isoblur(.,3))
#Returns an "imlist" object
imsplit(boats,"x",2) \%>\% map_il(~ isoblur(.,3))
#Fails if function returns an object that's not an image
try(imsplit(boats,"x",2) \%>\% map_il(~ . > 2))
}
\author{
Simon Barthelme
}
