% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drawing.R
\name{draw_circle}
\alias{draw_circle}
\title{Draw circle on image}
\usage{
draw_circle(im, x, y, radius, color = "white", opacity = 1, filled = TRUE)
}
\arguments{
\item{im}{an image}

\item{x}{x coordinates}

\item{y}{y coordinates}

\item{radius}{radius (either a single value or a vector of length equal to length(x))}

\item{color}{either a string ("red"), a character vector of length equal to x, or a matrix of dimension length(x) times spectrum(im)}

\item{opacity}{scalar or vector of length equal to length(x). 0: transparent 1: opaque.}

\item{filled}{fill circle (default TRUE)}
}
\value{
an image
}
\description{
Add circle or circles to an image. Like other native CImg drawing functions, this is meant to be basic but fast. Use implot for flexible drawing.
}
\examples{
draw_circle(boats,c(50,100),c(150,200),30,"darkgreen") \%>\% plot
draw_circle(boats,125,60,radius=30,col=c(0,1,0),opacity=.2,filled=TRUE) \%>\% plot
}
\seealso{
implot
}
\author{
Simon Barthelme
}
