% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/imglist.R
\name{ci}
\alias{ci}
\title{Concatenation for image lists}
\usage{
ci(...)
}
\arguments{
\item{...}{objects to concatenate}
}
\value{
an image list
}
\description{
Allows you to concatenate image lists together, or images with image lists.
Doesn't quite work like R's "c" primitive: image lists are always *flat*, not nested, meaning each element of an image list is an image.
}
\examples{

l1 <- imlist(boats,grayscale(boats))
l2 <- imgradient(boats,"xy")
ci(l1,l2) #List + list
ci(l1,imfill(3,3)) #List + image
ci(imfill(3,3),l1,l2) #Three elements, etc.
}
\author{
Simon Barthelme
}
