% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/piecewize_equalization.R
\name{EqualizePiecewise}
\alias{EqualizePiecewise}
\title{Enhance contrast of image by Piecewise Affine Equalization}
\usage{
EqualizePiecewise(im, N, smax = 255, smin = 0, range = c(0, 255))
}
\arguments{
\item{im}{a grayscale image of class cimg}

\item{N}{number of subintervals of partition. N controls how the input gray levels will be mapped in the output image.
if N is large, Piecewise Affine Equalization and Histogram Equalization are very similar.}

\item{smax}{maximum value of slopes. if smax is small, contrast enhancement is suppressed.}

\item{smin}{minimum value of slopes. if smin is large, contrast enhancement is propelled, and saturations occur excessively.}

\item{range}{range of the pixel values of image. this function assumes that the range of pixel values of of an input image is [0,255] by default. you may prefer [0,1].
if you change range, you should change smax. one example is this (smax = range[2] - range[1]).}
}
\value{
a grayscale image of class cimg
}
\description{
Enhance contrast of image by Piecewise Affine Equalization
}
\examples{
dev.new()
par(mfcol = c(1,2))
boats_g <- grayscale(boats)
plot(boats_g, main = "Original")
EqualizePiecewise(boats_g, 10) \%>\% plot(., main = "Piecewise Affine Equalization")
}
\references{
Jose-Luis Lisani, Ana-Belen Petro, and Catalina Sbert, Color and Contrast Enhancement by Controlled Piecewise Affine Histogram Equalization, Image Processing On Line, 2 (2012), pp. 243-265. \url{https://doi.org/10.5201/ipol.2012.lps-pae}
}
\author{
Shota Ochi
}
