% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fast_discrete_cosine_transoformation.R
\name{DCT}
\alias{DCT}
\alias{DCT2D}
\alias{IDCT2D}
\title{Two Dimensional Discrete Cosine Transformation and Inverse Cosine Transformation}
\usage{
DCT2D(imormat, returnmat = FALSE)

IDCT2D(imormat, returnmat = FALSE)
}
\arguments{
\item{imormat}{a grayscale image of class cimg or a numeric matrix}

\item{returnmat}{if returnmat is TRUE, returns numeric matrix. if FALSE, returns a grayscale image of class cimg.}
}
\value{
a grayscale image of class cimg or a numeric matrix
}
\description{
DCT2D computes two dimensional discrete cosine transformation.
IDCT2D computes two dimensional inverse discrete cosine transformation.
}
\examples{
g <- grayscale(boats)
layout(matrix(1:2, 1, 2))
plot(g, main = "Original")
gg <- DCT2D(g) \%>\% IDCT2D() \%>\% plot(main = "Transformed")
mean((g - gg)^2)
}
\references{
Makhoul, J. (1980). A fast cosine transform in one and two dimensions. IEEE Transactions on Acoustics, Speech, and Signal Processing. 28 (1): 27-34.
}
\author{
Shota Ochi
}
