% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_functions.R
\name{imf_codelist}
\alias{imf_codelist}
\title{Retreive the list of codes (codelist) for of an individual IMF database.}
\usage{
imf_codelist(database_id, return_raw = FALSE, times = 3)
}
\arguments{
\item{database_id}{character string of a \code{database_id} from
\code{\link{imf_ids}}.}

\item{return_raw}{logical. Whether to return the raw data
structure list or a data frame with codelist codes and descriptions.}

\item{times}{numeric. Maximum number of requests to attempt.}
}
\value{
If \code{return_raw = FALSE} then a data frame with the codelist IDs
and descriptions is returned. If \code{return_raw = TRUE} then the raw
data strcuture list is returned.
}
\description{
Retreive the list of codes (codelist) for of an individual IMF database.
}
\examples{
\dontrun{
# Find Balance of Payments database data structure
imf_codelist(database_id = 'BOP')
}
}
\seealso{
\code{\link{imf_ids}}
}
