% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extrFP.R
\name{extrFP}
\alias{extrFP}
\title{extrFP}
\usage{
extrFP(
  disease_biomarker,
  drug_target,
  method = "enrich",
  geneset = "ImmGenTop150"
)
}
\arguments{
\item{disease_biomarker}{A character of disease biomarkers or an order ranked geneList.}

\item{drug_target}{A data frame or list of drug target.}

\item{method}{one of "enrich" and "gsea"}

\item{geneset}{one of "ImmGenTop150" and "KEGG"}
}
\value{
ScoreFP object
}
\description{
Calculate the pathway fingerprints
}
\examples{

  data("drugSample")
  FP <- extrFP(disease_biomarker = drugSample$disease_biomarker,
               drug_target = drugSample$herb_target,
               method = "enrich",
               geneset = "ImmGenTop150")
}
\author{
Yuanlong Hu
}
