% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vis.R
\name{vis.immunr_kmer_table}
\alias{vis.immunr_kmer_table}
\title{Most frequent kmers visualisation.}
\usage{
\method{vis}{immunr_kmer_table}(
  .data,
  .head = 100,
  .position = c("stack", "dodge", "fill"),
  .log = FALSE,
  ...
)
}
\arguments{
\item{.data}{Data frame with two columns "Kmers" and "Count" or a list with such data frames. See Examples.}

\item{.head}{Number of the most frequent kmers to choose for plotting from each data frame.}

\item{.position}{Character vector of length 1. Position of bars for each kmers. Value for the \code{ggplot2} argument \code{position}.}

\item{.log}{Logical. If TRUE then plot log-scaled plots.}

\item{...}{Not used here.}
}
\value{
A ggplot2 object.
}
\description{
Plot a distribution (bar plot) of the most frequent kmers in a data.
}
\examples{
# Load necessary data and package.
data(immdata)
# Get 5-mers.
imm.km <- getKmers(immdata$data[[1]], 5)
# Plots for kmer proportions in each data frame in immdata.
p1 <- vis(imm.km, .position = "stack")
p2 <- vis(imm.km, .position = "fill")
p1 + p2
}
\seealso{
\code{get.kmers}
}
\concept{kmers}
