% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GLstring_genes.R
\name{GLstring_genes}
\alias{GLstring_genes}
\title{GLstring_genes}
\usage{
GLstring_genes(data, gl_string)
}
\arguments{
\item{data}{A data frame}

\item{gl_string}{The name of the column in the data frame that contains
GL strings}
}
\value{
A data frame with GL strings separated, loci identified, and data
transformed to a wider format with loci as columns.
}
\description{
This function processes a specified column in a data frame
that contains GL strings. It separates the GL strings, identifies the HLA
loci, and transforms the data into a wider format with loci as column names.
}
\examples{

file <- HLA_typing_1[, -1]
GL_string <- data.frame("GL_string" = HLA_columns_to_GLstring(
  file,
  HLA_typing_columns = everything()
))
GL_string <- GL_string[1, , drop = FALSE] # When considering first patient
result <- GLstring_genes(GL_string, "GL_string")
print(result)

}
