% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/implicitExpansion.R
\name{mmapply}
\alias{mmapply}
\title{Apply a Function to Multiple Arrays with Implicit Expansion}
\usage{
mmapply(FUN, ..., SIMPLIFY = TRUE, USE.NAMES = TRUE)
}
\arguments{
\item{FUN}{Function to apply to each combination of arguments. Found via \code{\link{match.fun}}.}

\item{...}{Objects that are coerced to arrays, expanded using implicit expansion, and then vectorized over.}

\item{SIMPLIFY}{If \code{TRUE}, the resulting list array is simplified to an atomic array if possible.}

\item{USE.NAMES}{If \code{TRUE}, the dimensions are named using the names of input arguments of matching size.}
}
\value{
An array containing the result of \code{FUN} for each combination of entries from \code{...} after implicit expansion.
}
\description{
Similar function to \code{\link{mapply}} with support for implicit expansion.
}
\details{
The arguments are handled in a similar fashion to \code{\link{mapply}} with some key differences:
\itemize{
\item \code{MoreArgs} is omitted, since additional arguments can be passed in \code{...}, either as they are
(if they are atomic), or as a \code{list()} of length one.
\item \code{SIMPLIFY} only simplifies a list array to an atomic array, nothing else.
\item \code{USE.NAMES} uses names from all arguments, but never uses an argument itself as names.
}
}
\examples{
summaries <- list(Max = max, Min = min, avg = mean)
data <- list(a = 1:5, b = 2:3, c = 20:12)
formatStrings <- array(c('\%.1f', '\%.3f'), c(1,1,2))
mmapply(function(f, d, s) sprintf(s, f(d)), summaries, t(data), formatStrings)

}
\seealso{
\code{\link{expandArray}}, \code{\link{expandedDim}}
}
