% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clean_iat.R
\name{clean_iat}
\alias{clean_iat}
\title{Prepare and clean IAT data.}
\usage{
clean_iat(
  data,
  sbj_id = "participant",
  block_id = "blockcode",
  mapA_practice = "practice_MappingA",
  mapA_test = "test_MappingA",
  mapB_practice = "practice_MappingB",
  mapB_test = "test_MappingB",
  latency_id = "latency",
  accuracy_id = "correct",
  trial_id = NULL,
  trial_eliminate = NULL,
  demo_id = NULL,
  trial_demo = NULL
)
}
\arguments{
\item{data}{Dataframe containing IAT data.}

\item{sbj_id}{Column identifying participants' IDs. This variable can be a \code{character},
\code{numeric}, or \code{factor}.}

\item{block_id}{String. Column identifying
IAT blocks. The \code{block_id} variable should be a
\code{factor} with each level identifying an IAT block.}

\item{mapA_practice}{String. Label for the practice blocks of Mapping A (as
it appears in the \code{block_id} variable).}

\item{mapA_test}{String. Label for the test blocks of Mapping A (as
it appears in the \code{block_id} variable).}

\item{mapB_practice}{String. Label for the practice blocks of Mapping B (as
it appears in the \code{block_id} variable).}

\item{mapB_test}{String. Label for the test blocks of Mapping B (as
it appears in the \code{block_id} variable).}

\item{latency_id}{String. Column identifying
response times (in millisecond). If the IAT had a
built-in correction, latencies of the incorrect responses
should be those inflated with the built-in correction.}

\item{accuracy_id}{String. Column identifying the
IAT accuracy responses. The \code{accuracy_id} variable
should be a numeric variable identifying the correct
responses (with 1) and the incorrect responses (with 0).}

\item{trial_id}{Character. Column identifying the trials. Specify this only
if you want to delete some specific trials.}

\item{trial_eliminate}{Character or character vector. Label(s) identifying the trials
in \code{trial_id} to eliminate.}

\item{demo_id}{Character. Column identifying demographic blocks. It can be the same as \code{block_id}.}

\item{trial_demo}{Character or character vector identifying the name of the
blocks in \code{demo_id} containing the demographic information.}
}
\value{
List of dataframe.
 \describe{
    \item{\code{data_keep}}{Dataframe with class \code{iat_clean}. The
    dataframe contains the data of the blocks specified in
    \code{mapA_practice}, \code{mapA_test}, \code{mapB_practice},
    \code{mapB_test}. If you have specified the trials to eliminate through
    \code{trial_eliminate}, \code{data_keep} will contain the already
     cleaned dataset. This dataset should be passed to the \code{computeD} function.}
    \item{\code{data_eliminate}}{Dataframe containing all the discarded
     blocks and trials.}
    \item{\code{data_demo}}{Dataframe containing demographic variables.
     It will be present only if you specified the \code{demo_id} and
     \code{trial_demo} arguments.}
    }
}
\description{
Select IAT blocks for the \emph{D-score} computation and eventually save demographic data.
}
\examples{
data("raw_data") # load data
iat_cleandata <- clean_iat(raw_data, sbj_id = "Participant",
                          block_id = "blockcode",
                          mapA_practice = "practice.iat.Milkbad",
                          mapA_test = "test.iat.Milkbad",
                          mapB_practice = "practice.iat.Milkgood",
                          mapB_test = "test.iat.Milkgood",
                          latency_id = "latency",
                          accuracy_id = "correct",
                          trial_id = "trialcode",
                          trial_eliminate = c("reminder", "reminder1"),
                          demo_id = "blockcode",
                          trial_demo = "demo")
iat_data <- iat_cleandata[[1]] # select the first element of the list (IAT data)
head(iat_data)
demo_data <- iat_cleandata[[3]] # select the third element of the list
                            # (demographic data)
head(demo_data)
}
