% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/censo_poblacion_urbano.R
\name{censo_poblacion_urbano}
\alias{censo_poblacion_urbano}
\title{Censo de Poblacion - Entorno urbano}
\usage{
censo_poblacion_urbano(year = NA, estado = NA)
}
\arguments{
\item{year}{Año del levantamiento del censo en formato numerico. Los años disponibles (incluyendo los conteos) son: 2000, 2005, 2010 y 2015.}

\item{estado}{Define el nombre de la entidad federativa para descargar los datos en formato alfanumerico. Los nombres de los estados deben ir capitalizados (y en su caso, con espacios), por ejemplo: "Aguascalientes", "CDMX", "San Luis Potosi".}
}
\value{
Data.frame
}
\description{
Censo de Poblacion y Vivienda. Resultados sobre infraestructura y caracteristicas del entorno urbano.
}
\details{
Esta base de datos tiene dos niveles de agregacion: entidades federativas y municipios.
}
\examples{

# Consultar los datos del entorno urbano del Censo de Poblacion y Vivienda
\donttest{censo_poblacion_entorno()}

# Descargar los datos de CDMX de 2010.
\donttest{urbano = censo_poblacion_entorno(year = 2010, estado = "CDMX")}
}
