% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/probinterval.R
\name{probInterval}
\alias{probInterval}
\title{Various method around IPIntervals}
\usage{
probInterval(table, iptype = c("IDM", "NPI", "NPIapprox"),
  entropymin = TRUE, entropymax = TRUE, correction = c("no",
  "strobl", "abellan"), s = 1)
}
\arguments{
\item{table}{integer vector of absolute frequencies}

\item{iptype}{method for calculating the probability
intervals of \code{table}. \code{"IDM"} for the imprecise
Dirichlet model (default), \code{"NPI"} for use of the 
nonparametric predictive inference approach and \code{"NPIapprox"}
for use of the approximate algorithm obtaining maximal entropy of
NPI generated probability intervals.}

\item{entropymin}{Calculation of one distribution with minimal 
entropy, including the actual value of the minimal entropy
(default: \code{TRUE})}

\item{entropymax}{Calculation of the distribution with maximal 
entropy, including the actual value of the maximal entropy
(default: \code{TRUE})}

\item{correction}{Entropy correction to be carried out,
ignorned if \code{(entropymin || entropymax) == FALSE}
(default \code{"no"}), see \code{\link{imptree_params}}}

\item{s}{Hyperparamter of the IDM (\code{s >= 0}),
see \code{\link{imptree_params}} 
(ignored for \code{iptype == "NPI"})}
}
\value{
A list with 5 named entries:
\item{probint}{matrix with 3 rows and \code{length(table)}
columns: in the rows are the abosulte frequencies, the lower 
bound (\code{"lower"}) and the upper bound (\code{"upper"}) 
of the event-wise probabilities.}
\item{maxEntDist}{The (unique) probability distribution with
maximal entropy}
\item{maxEntCorr}{The value of the (corrected) maximal entropy}
\item{minEntDist}{A probability distribution with minimal
entropy, as it is not necessarily unqiue there may be others}
\item{minEntCorr}{The value of the (corrected) minimal entropy}
}
\description{
Calculation of probability intervals, 
and their maximal and minimal entropy
}
\examples{
## Artificial vector of absolute frequencies
obs <- c(a = 1,b = 2, c = 10, d = 30, e = 5)

## probability interval by NPI, including only information on the
## mininum entropy distribution, using no entropy correction
probInterval(obs, iptype = "NPI", entropymax = FALSE)

## probability interval by IDM, including information on the
## minimum and maximum entropy distribution with s = 2 and correction
## according to 'strobl'
probInterval(obs, iptype = "IDM", correction = "strobl", s = 2)

}
\seealso{
\code{\link{imptree_params}}
}
\author{
Paul Fink \email{Paul.Fink@stat.uni-muenchen.de}
}
