% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cut.integer.R
\name{cut.integer}
\alias{cut.integer}
\title{Convert integer vector to Factor}
\usage{
\method{cut}{integer}(x, ...)
}
\arguments{
\item{x}{integer vector}

\item{...}{further arguments passed to or from other methods}
}
\value{
If \code{cut.default(x, ...)} returns only integer intervals, these are 
formatted in a more natural way and returned as an ordered factor.
If non integer interval limits occur, the output of \code{cut.default(x, ...)} 
is returned as is.
}
\description{
S3-method for cut applied to integer vectors where all outcome 
factors are integer intervals.
}
\examples{
cut.default(1:100, seq(0, 100, 20)) # Gives a quite unnatural output
cut(1:100, seq(0, 100, 20)) # Gives nicer and ordered output
cut(1:10, 3) # no integer intervals and therefor same as cut.default
}
