% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is.wholenumber.R
\name{is.wholenumber}
\alias{is.wholenumber}
\title{Test if a numeric vector consists of whole numbers}
\usage{
is.wholenumber(x, tol = .Machine$double.eps^0.5)
}
\arguments{
\item{x}{a numeric vector}

\item{tol}{How much is \code{x} allowed to deviate from \code{round(x)} to 
be a whole number.}
}
\value{
Logical vector with same length as \code{x}.
}
\description{
Function borrowed from the example section for \code{\link{integer}}.
}
\examples{
is.wholenumber(1) # is TRUE
(x <- seq(1, 5, by = 0.5) )
is.wholenumber( x ) #-->  TRUE FALSE TRUE ...
}
