% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calibration_frr.R
\name{frrcal}
\alias{frrcal}
\title{Estimate False-Recent Rate}
\usage{
frrcal(data = NULL, subid_var = NULL, time_var = NULL,
  recency_cutoff_time = 730.5, recency_rule = "binary_data",
  recency_vars = NULL, recency_params = NULL, alpha = 0.05,
  debug = FALSE)
}
\arguments{
\item{data}{A data frame containing variables for subject identifier, time (since detectable infection), and variables with biomarker readings or recency status (to be specified in recency_vars)}

\item{subid_var}{The variable in the dataframe identifying subjects}

\item{time_var}{The variable in the dataframe indicating time between 'time zero' (usually detectable infection) and biomarker measurement}

\item{recency_cutoff_time}{Recency time cut-off ('Big T'). Default=730.5.}

\item{recency_rule}{Specified rule for defining recent/non-recent outcomes from biomarker data (see Details)}

\item{recency_vars}{Variables to be used in determining recency outcomes}

\item{recency_params}{Vector of numeric parameters (e.g. thresholds) for determining recency according to the relevant rule}

\item{alpha}{Confidence level, default=0.05.}

\item{debug}{Enable debugging mode (browser)}
}
\description{
Estimates subject-level false-recent rate (FRR) for a given time cutoff.
Each subject with any observations after the time cutoff is assigned a recency status according to the majority
of observations for that subject after the cutoff. In the event of exactly half of the observations being
classified as recent, the subject contributes a count of 0.5.
The function performs an exact binomial test and reports the estimated probability of testing recent after the
cutoff, a confidence interval for the proportion, the number of recent results ('successes'),
number of subjects ('trials') and the number of data points contributing to the subject-level estimate.
}
\details{
The package contains long form documentation in the form of vignettes that cover the use of the main fucntions. Use browseVignettes(package="inctools") to access them.

recency_rule: binary_data - supply a binary variable with 1=recent and 0=non-recent in recency_vars.

recency_rule: independent_thresholds: supply one threshold variable per biomarker in recency_vars and the relevant
thresholds, as well as whether a value below or above each threshold indicates recency in recency_params.

recency_params expects a list of pairs of thresholds and thresholdtypes, with zero indicating a reading below
the threshold implies recency and 1 that a reading above the threshold implies recency. (Note: two values,
a threshold and a thresholdtype per variable must be specified in recency_params. For example, if you specify
recency_vars = c('ODn','ViralLoad') you may specify recency_params = c(1.5,0,500,1), meaning that an ODn reading
below 1.5 AND a viral load reasing above 500 indicates a recent result. Objects with missing values in its
 biomarker readings will be excluded from caculation.
}
\examples{
frrcal(data=excalibdata,
       subid_var = "SubjectID",
       time_var = "DaysSinceEDDI",
       recency_cutoff_time = 730.5,
       recency_rule = "independent_thresholds",
       recency_vars = c("Result","VL"),
       recency_params = c(10,0,1000,1),
       alpha = 0.05)
}
