% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/delay.R
\name{DelayedWeibull}
\alias{DelayedWeibull}
\alias{dweib_delayed}
\alias{pweib_delayed}
\alias{qweib_delayed}
\alias{rweib_delayed}
\title{Delayed Weibull Distribution}
\usage{
dweib_delayed(x, delay, shape, scale = 1, ...)

pweib_delayed(q, delay, shape, scale = 1, ...)

qweib_delayed(p, delay, shape, scale = 1, ...)

rweib_delayed(n, delay, shape, scale = 1)
}
\arguments{
\item{x}{A numeric vector of values for which to get the density.}

\item{delay}{numeric. The delay, must be non-negative.}

\item{shape}{numeric. Shape parameter, must be positive.}

\item{scale}{numeric. Scale parameter (inverse of rate), must be positive.}

\item{...}{further arguments are passed on to the underlying non-delayed function, e.g., \code{\link[stats:Weibull]{stats::dweibull()}}}

\item{q}{A numeric vector of quantile values.}

\item{p}{A numeric vector of probabilities.}

\item{n}{integer. Number of random observations requested.}
}
\value{
\code{dweib_delayed} gives the density, \code{pweib_delayed} gives the distribution function, \code{qweib_delayed} gives the quantile function,
and \code{rweib_delayed} generates a pseudo-random sample from the delayed Weibull distribution.

The length of the result is determined by \code{n} for \code{rweib_delayed}, and is the maximum of the lengths of the numerical arguments for the other functions.
}
\description{
Density, distribution function, quantile function and random generation for the delayed Weibull distribution with parameters
as in the Weibull distribution functions in R's stats-package, namely:
\itemize{
\item \code{delay}
\item \code{shape}
\item \code{scale} (inverse of rate)
}
}
\details{
Additional arguments are forwarded via \code{...} to the underlying functions of the exponential distribution in the stats-package.

The numerical arguments other than \code{n} are recycled to the length of the result. Only the first elements of the logical arguments are used.
}
\keyword{distribution}
