% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/categorical_variable.R
\name{CategoricalVariable}
\alias{CategoricalVariable}
\title{Categorical Variable Class}
\description{
Represents a categorical variable for an individual.
This class should be used for discrete variables taking values in 
a finite set, such as infection, health, or behavioral state. It should
be used in preference to \code{\link[individual]{IntegerVariable}}
if possible becuase certain operations will be faster.
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{CategoricalVariable$new()}}
\item \href{#method-get_index_of}{\code{CategoricalVariable$get_index_of()}}
\item \href{#method-get_size_of}{\code{CategoricalVariable$get_size_of()}}
\item \href{#method-get_categories}{\code{CategoricalVariable$get_categories()}}
\item \href{#method-queue_update}{\code{CategoricalVariable$queue_update()}}
\item \href{#method-.update}{\code{CategoricalVariable$.update()}}
\item \href{#method-clone}{\code{CategoricalVariable$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Create a new CategoricalVariable
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CategoricalVariable$new(categories, initial_values)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{categories}}{a character vector of possible values}

\item{\code{initial_values}}{a character vector of the initial value for each
individual}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-get_index_of"></a>}}
\if{latex}{\out{\hypertarget{method-get_index_of}{}}}
\subsection{Method \code{get_index_of()}}{
return a \code{\link[individual]{Bitset}} for individuals with the given \code{values}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CategoricalVariable$get_index_of(values)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{values}}{the values to filter}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-get_size_of"></a>}}
\if{latex}{\out{\hypertarget{method-get_size_of}{}}}
\subsection{Method \code{get_size_of()}}{
return the number of individuals with the given \code{values}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CategoricalVariable$get_size_of(values)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{values}}{the values to filter}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-get_categories"></a>}}
\if{latex}{\out{\hypertarget{method-get_categories}{}}}
\subsection{Method \code{get_categories()}}{
return a character vector of possible values.
Note that the order of the returned vector may not be the same order
that was given when the variable was intitialized, due to the underlying
unordered storage type.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CategoricalVariable$get_categories()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-queue_update"></a>}}
\if{latex}{\out{\hypertarget{method-queue_update}{}}}
\subsection{Method \code{queue_update()}}{
queue an update for this variable
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CategoricalVariable$queue_update(value, index)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{index}}{the indices of individuals whose value will be updated
to the one specified in \code{values}. This may be either a vector of integers or
a \code{\link[individual]{Bitset}}.}

\item{\code{values}}{the new values}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-.update"></a>}}
\if{latex}{\out{\hypertarget{method-.update}{}}}
\subsection{Method \code{.update()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CategoricalVariable$.update()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CategoricalVariable$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
