% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualize.R
\name{shade_p_value}
\alias{shade_p_value}
\alias{shade_pvalue}
\title{Add information about p-value region(s)}
\usage{
shade_p_value(obs_stat, direction, color = "red2", fill = "pink", ...)

shade_pvalue(obs_stat, direction, color = "red2", fill = "pink", ...)
}
\arguments{
\item{obs_stat}{A numeric value or 1x1 data frame corresponding to what the
observed statistic is.}

\item{direction}{A string specifying in which direction the shading should
occur. Options are \code{"less"}, \code{"greater"}, or \code{"two_sided"}. Can
also give \code{"left"}, \code{"right"}, or \code{"both"}. If \code{NULL} then no shading is
actually done.}

\item{color}{A character or hex string specifying the color of the observed
statistic as a vertical line on the plot.}

\item{fill}{A character or hex string specifying the color to shade the
p-value region. If \code{NULL} then no shading is actually done.}

\item{...}{Other arguments passed along to \{ggplot2\} functions.}
}
\value{
A list of \{ggplot2\} objects to be added to the \code{visualize()}
output.
}
\description{
\code{shade_p_value()} plots p-value region(s) on top of the \code{\link[=visualize]{visualize()}} output.
It should be used as \{ggplot2\} layer function (see examples).
\code{shade_pvalue()} is its alias.
}
\examples{
viz_plot <- mtcars \%>\%
  dplyr::mutate(am = factor(am)) \%>\%
  specify(mpg ~ am) \%>\% # alt: response = mpg, explanatory = am
  hypothesize(null = "independence") \%>\%
  generate(reps = 100, type = "permute") \%>\%
  calculate(stat = "t", order = c("1", "0")) \%>\%
  visualize(method = "both")

viz_plot + shade_p_value(1.5, direction = "right")
viz_plot + shade_p_value(1.5, direction = "both")
viz_plot + shade_p_value(1.5, direction = NULL)

}
\seealso{
\code{\link[=shade_confidence_interval]{shade_confidence_interval()}} to add information about confidence
interval.
}
