% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{filter.sort.matrix}
\alias{filter.sort.matrix}
\title{Filter and sort matrix}
\usage{
filter.sort.matrix(weight_matrix, regulators = NULL, targets = NULL)
}
\arguments{
\item{weight_matrix}{The matrix of network weight.}

\item{regulators}{Regulators list.}

\item{targets}{Targets list.}
}
\value{
Filtered and sorted matrix
}
\description{
Filter and sort matrix
}
\examples{
library(inferCSN)
data("example_matrix")
weight_table <- inferCSN(example_matrix)
weight_matrix <- table.to.matrix(weight_table)
filter.sort.matrix(weight_matrix)[1:6, 1:6]

filter.sort.matrix(
  weight_matrix ,
  regulators = c("g1", "g2"),
  targets = c("g3", "g4")
)
}
