% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/network.visualization.R
\name{dynamic.networks}
\alias{dynamic.networks}
\title{Plot of dynamic networks}
\usage{
dynamic.networks(
  weight_table,
  regulators = NULL,
  targets = NULL,
  legend_position = "right"
)
}
\arguments{
\item{weight_table}{The weight data table of network.}

\item{regulators}{Regulators list.}

\item{targets}{Targets list.}

\item{legend_position}{The position of legend.}
}
\value{
A list of ggplot2 objects
}
\description{
Plot of dynamic networks
}
\examples{
library(inferCSN)
data("example_matrix")
weight_table <- inferCSN(example_matrix)
dynamic.networks(
  weight_table,
  regulators = weight_table[1, 1]
)
dynamic.networks(
  weight_table,
  targets = weight_table[1, 1]
)
dynamic.networks(
  weight_table,
  regulators = weight_table[1, 1],
  targets = weight_table[1, 2]
)
}
