% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/infer-ts-var-test.R
\name{infer_ts_var_test}
\alias{infer_ts_var_test}
\alias{var_test}
\title{Two Sample Variance Comparison Test}
\usage{
infer_ts_var_test(variable, ..., group_var = NA, alternative = c("less",
  "greater", "all"))
}
\arguments{
\item{variable}{a numeric vector}

\item{...}{numeric vectors}

\item{group_var}{a grouping variable}

\item{alternative}{a character string specifying the alternative hypothesis,
must be one of "both" (default), "greater", "less" or "all". You can specify
just the initial letter.}
}
\value{
\code{infer_ts_var_test} returns an object of class \code{"infer_ts_var_test"}.
An object of class \code{"infer_ts_var_test"} is a list containing the
following components:

\item{f}{f statistic}
\item{lower}{lower one-sided p-value}
\item{upper}{upper one-sided p-value}
\item{two_tail}{two-sided p-value}
\item{vars}{variances for each level of the grouping variable}
\item{avgs}{means for each level of the grouping variable}
\item{sds}{standard deviations for each level of the grouping variable}
\item{ses}{standard errors for each level of the grouping variable}
\item{avg}{combined mean}
\item{sd}{combined standard deviation}
\item{se}{estimated combined standard error}
\item{n1}{numerator degrees of freedom}
\item{n2}{denominator degrees of freedom}
\item{lens}{number of observations for each level of grouping variable}
\item{len}{number of observations}
\item{lev}{levels of the grouping variable}
\item{type}{alternative hypothesis}
}
\description{
\code{infer_ts_var_test} performs tests on the equality of standard
deviations (variances).
}
\section{Deprecated Function}{

\code{var_test()} has been deprecated. Instead use \code{infer_ts_var_test()}.
}

\examples{
# using grouping variable
# lower tail
infer_ts_var_test(mtcars$mpg, group_var = mtcars$vs, alternative = 'less')

# upper tail
infer_ts_var_test(mtcars$mpg, group_var = mtcars$vs, alternative = 'greater')

# all tails
infer_ts_var_test(mtcars$mpg, group_var = mtcars$vs, alternative = 'all')

# using two variables
# lower tail
infer_ts_var_test(hsb$read, hsb$write, alternative = 'less')

# upper tail
infer_ts_var_test(hsb$read, hsb$write, alternative = 'greater')

# all tails
infer_ts_var_test(hsb$read, hsb$write, alternative = 'all')

}
\references{
Sheskin, D. J. 2007. Handbook of Parametric and Nonparametric
Statistical Procedures, 4th edition. : Chapman & Hall/CRC.
}
\seealso{
\code{\link[stats]{var.test}}
}
