% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/show_observations.R
\name{show_observations}
\alias{show_observations}
\title{Adds a Layer with Observations to a Profile Plot}
\usage{
show_observations(x, ..., size = 2, alpha = 1, color = "#371ea3",
  variable_type = "numerical", variables = NULL)
}
\arguments{
\item{x}{a ceteris paribus explainer produced with function \code{ceteris_paribus()}}

\item{...}{other explainers that shall be plotted together}

\item{size}{a numeric. Size of lines to be plotted}

\item{alpha}{a numeric between 0 and 1. Opacity of lines}

\item{color}{a character. Either name of a color or name of a variable that should be used for coloring}

\item{variable_type}{a character. If "numerical" then only numerical variables will be plotted.
If "categorical" then only categorical variables will be plotted.}

\item{variables}{if not \code{NULL} then only \code{variables} will be presented}
}
\value{
a \code{ggplot2} layer
}
\description{
Function \code{\link{show_observations}} adds a layer to a plot created with
\code{\link{plot.ceteris_paribus_explainer}} for selected observations.
Various parameters help to decide what should be plotted, profiles, aggregated profiles, points or rugs.
}
\examples{
library("DALEX")
library("randomForest")

rf_model <- randomForest(survived == "yes" ~.,
                         data = titanic_imputed)

explainer_rf <- explain(rf_model, data = titanic_imputed,
                        y = titanic_imputed$survived == "yes",
                        label = "RF", verbose = FALSE)

selected_passangers <- select_sample(titanic_imputed, n = 100)
cp_rf <- ceteris_paribus(explainer_rf, selected_passangers)
cp_rf

plot(cp_rf, variables = "age", color = "grey") +
show_observations(cp_rf, variables = "age", color = "black") +
  show_rugs(cp_rf, variables = "age", color = "red")


}
