% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{raw_df_exposures}
\alias{raw_df_exposures}
\title{Minimal example of exposure data}
\format{
A data frame with 42 rows corresponding to 28 football players and 16
variables: \describe{
\item{player_name}{Name of the football player (factor)}
\item{player_id}{Identification number of the football player (factor)}
\item{season}{Season to which this player's entry corresponds (factor)}
\item{year}{Year in which each season started (numeric)}
\item{matches_played}{Matches played by the player in each season (numeric)}
\item{minutes_played}{Minutes played by the player in each season (numeric)}
\item{liga}{Name of the ligue where the player played in each season (factor)}
\item{club_name}{Name of the club to which the player belongs in each season (factor)}
\item{club_id}{Identification number of the club to which the player belongs in each season (factor)}
\item{age}{Age of the player in each season (numeric)}
\item{height}{Height of the player in m (numeric)}
\item{place}{Place of birth of each player (character)}
\item{citizenship}{Citizenship of the player (factor)}
\item{position}{Position of the player on the pitch (factor)}
\item{foot}{Dominant leg of the player. One of both, left or right (factor)}
\item{goals}{Number of goals scored by the player in that season (numeric)}
\item{assists}{Number of assists provided by the player in that season (numerical)}
\item{yellows}{Number of the yellow cards received by the player in that season (numeric)}
\item{reds}{Number of the red cards received by the player in that season (numeric)}}
}
\source{
\url{https://www.transfermarkt.com/}
}
\usage{
raw_df_exposures
}
\description{
An example of a player exposure data set that contains minimum required
exposure information as well as other player- and match-related variables. It
includes Liverpool Football Club male's first team players' exposure data,
exposure measured as (number or minutes of) matches played, over two
consecutive seasons, 2017-2018 and 2018-2019. Each row refers to
player-season. These data have been scrapped from
\url{https://www.transfermarkt.com/} website using self-defined \strong{R} code
with \code{rvest} and \code{xml2} packages.
}
\note{
This data frame is provided for illustrative purposes. We warn that
they might not be accurate, there might be a mismatch and non-completeness
with what actually occurred. As such, its use cannot be recommended for
epidemiological research (see also Hoenig et al., 2022).
}
\references{
Hoenig, T., Edouard, P., Krause, M., Malhan, D., Relógio, A.,
Junge, A., & Hollander, K. (2022). Analysis of more than 20,000 injuries in
European professional football by using a citizen science-based approach:
An opportunity for epidemiological research?. \emph{Journal of science and
medicine in sport}, 25(4), 300-305.
}
\keyword{datasets}
