% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inla.R
\name{predict.inla}
\alias{predict.inla}
\title{Prediction from fitted inla model}
\usage{
\method{predict}{inla}(object, ...)
}
\arguments{
\item{object}{An object obtained by calling \link{bru} or \link{lgcp}.}

\item{...}{Arguments passed on to predict.bru().}
}
\value{
A \code{prediction} object.
}
\description{
Takes a fitted inla object produced by the function inla() and produces predictions given a 
new set of values for the model covariates or the original values used for the model fit. 
The predictions can be based on any R expression that is valid given these values/covariates 
and the posterior of the estimated effects.
}
\details{
IMPORTANT: The inla object provided has to have an additional field called "formula". This
is the formula used to call the inla() function and will be used to convert the inla object
to a bru object. Thereafter, preict.bru() is called to perform the prediction.
}
\examples{
\dontrun{

# Generate some data

input.df <- data.frame(x=cos(1:10))
input.df <- within(input.df, y <- 5 + 2*cos(1:10) + rnorm(10, mean=0, sd=0.1))

# Fit a Gaussian likelihood model

formula = y ~ x
fit <- inla(formula, "gaussian", data = input.df, control.compute=list(config = TRUE))

# Add formula to inla object

fit$formula = y ~ x

Estimate posterior statistics of exp(x), where x is the random effect.

xpost = predict(fit, NULL, ~ exp(x))
xpost
plot(xpost)

}
}
\author{
Fabian E. Bachl <\email{bachlfab@gmail.com}>
}
