% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bru.inference.R
\name{bru_response_size}
\alias{bru_response_size}
\alias{bru_response_size.bru_like}
\alias{bru_response_size.bru_like_list}
\alias{bru_response_size.bru_info}
\alias{bru_response_size.bru}
\title{Response size queries}
\usage{
bru_response_size(object)

\method{bru_response_size}{bru_like}(object)

\method{bru_response_size}{bru_like_list}(object)

\method{bru_response_size}{bru_info}(object)

\method{bru_response_size}{bru}(object)
}
\arguments{
\item{object}{An object from which to extract response size(s).}
}
\value{
An \code{integer} vector.
}
\description{
Extract the number of response values from \code{bru} and related objects.
}
\section{Methods (by class)}{
\itemize{
\item \code{bru_response_size(bru_like)}: Extract the number of observations from a
\code{bru_like} object.

\item \code{bru_response_size(bru_like_list)}: Extract the number of observations from a
\code{bru_like_list} object.

\item \code{bru_response_size(bru_info)}: Extract the number of observations from a
\code{bru_info} object.

\item \code{bru_response_size(bru)}: Extract the number of observations from a
\code{bru} object.

}}
\examples{
bru_response_size(
  bru_obs(y ~ 1, data = data.frame(y = rnorm(10)), family = "gaussian")
)
}
\seealso{
\code{\link[=like]{like()}}
}
