% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bru.spatial.R, R/deprecated.R, R/environment.R,
%   R/fmesher_crs.R, R/mappers.R, R/mesh.R, R/utils.R
\name{stransform}
\alias{stransform}
\alias{inlabru-deprecated}
\alias{init.tutorial}
\alias{fm_has_PROJ6}
\alias{fm_not_for_PROJ6}
\alias{fm_not_for_PROJ4}
\alias{fm_fallback_PROJ6}
\alias{fm_requires_PROJ6}
\alias{fm_sp_get_crs}
\alias{fm_spTransform}
\alias{fm_spTransform.default}
\alias{fm_spTransform.SpatialPoints}
\alias{fm_spTransform.SpatialPointsDataFrame}
\alias{fm_spTransform.inla.mesh.lattice}
\alias{fm_spTransform.inla.mesh.segment}
\alias{fm_spTransform.inla.mesh}
\alias{ibm_valid_input}
\alias{ibm_amatrix.bru_mapper_inla_mesh_2d}
\alias{ibm_amatrix.bru_mapper_inla_mesh_1d}
\alias{ibm_amatrix.bru_mapper_index}
\alias{ibm_amatrix.bru_mapper_linear}
\alias{ibm_amatrix.bru_mapper_matrix}
\alias{ibm_amatrix.bru_mapper_factor}
\alias{bru_mapper_offset}
\alias{ibm_n.bru_mapper_offset}
\alias{ibm_values.bru_mapper_offset}
\alias{ibm_amatrix.bru_mapper_offset}
\alias{ibm_amatrix.bru_mapper_multi}
\alias{ibm_amatrix.bru_mapper_collect}
\alias{vertices.inla.mesh}
\alias{eval_SpatialDF}
\title{Deprecated functions in inlabru}
\usage{
stransform(splist, crs)

init.tutorial()

fm_has_PROJ6()

fm_not_for_PROJ6(fun = NULL)

fm_not_for_PROJ4(fun = NULL)

fm_fallback_PROJ6(fun = NULL)

fm_requires_PROJ6(fun = NULL)

fm_sp_get_crs(x)

fm_spTransform(x, ...)

\method{fm_spTransform}{default}(x, crs0 = NULL, crs1 = NULL, passthrough = FALSE, ...)

\method{fm_spTransform}{SpatialPoints}(x, CRSobj, passthrough = FALSE, ...)

\method{fm_spTransform}{SpatialPointsDataFrame}(x, CRSobj, passthrough = FALSE, ...)

\method{fm_spTransform}{inla.mesh.lattice}(x, CRSobj, passthrough = FALSE, ...)

\method{fm_spTransform}{inla.mesh.segment}(x, CRSobj, passthrough = FALSE, ...)

\method{fm_spTransform}{inla.mesh}(x, CRSobj, passthrough = FALSE, ...)

ibm_valid_input(...)

\method{ibm_amatrix}{bru_mapper_inla_mesh_2d}(...)

\method{ibm_amatrix}{bru_mapper_inla_mesh_1d}(...)

\method{ibm_amatrix}{bru_mapper_index}(...)

\method{ibm_amatrix}{bru_mapper_linear}(...)

\method{ibm_amatrix}{bru_mapper_matrix}(...)

\method{ibm_amatrix}{bru_mapper_factor}(...)

bru_mapper_offset(...)

\method{ibm_n}{bru_mapper_offset}(...)

\method{ibm_values}{bru_mapper_offset}(...)

\method{ibm_amatrix}{bru_mapper_offset}(...)

\method{ibm_amatrix}{bru_mapper_multi}(...)

\method{ibm_amatrix}{bru_mapper_collect}(...)

vertices.inla.mesh(...)

eval_SpatialDF(...)
}
\arguments{
\item{splist}{list of Spatial* objects}

\item{crs}{Coordinate reference system to change to}

\item{fun}{The name of the function that requires PROJ6. Default: NULL,
which uses the name of the calling function.}

\item{x}{The object that should be transformed from it's current CRS to a new CRS}

\item{\dots}{Potential additional arguments}

\item{crs0}{The source sp::CRS or inla.CRS object}

\item{crs1}{The target sp::CRS or inla.CRS object}

\item{passthrough}{Default is FALSE.
Setting to TRUE allows objects with no CRS information to be passed
through without transformation.}

\item{CRSobj}{The target sp::CRS or inla.CRS object}
}
\value{
A \code{CRS} object, or NULL if no valid CRS identified
}
\description{
These functions still attempt to do their job, but will be removed in a
future version.
}
\details{
This function is a convenience method to workaround PROJ4/PROJ6
differences, and the lack of a crs extraction method for Spatial objects.
For newer code, use \code{\link[=fm_crs]{fm_crs()}} instead, that returns \code{crs} objects,
and use \code{\link[=fm_as_sp_crs]{fm_as_sp_crs()}} to convert to old style \code{sp::CRS} objects.
}
\section{Functions}{
\itemize{
\item \code{stransform()}: Coordinate transformation for spatial objects

This is a wrapper for the \link[sp:spTransform]{spTransform} function provided by the \code{sp} package.
Given a spatial object (or a list thereof) it will transform the coordinate system according
to the parameter \code{crs}. In addition to the usual spatial objects this function is
also capable of transforming \code{INLA::inla.mesh} objects that are equipped with a coordinate
system. Returns a list of Spatial* objects.

\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} Deprecated in favour of the \code{fm_transform} methods.

\item \code{init.tutorial()}: Global setting for tutorial sessions.

Use \code{\link[=bru_options_set]{bru_options_set()}} to set specific
options instead instead.  In versions <= 2.1.15, this function set the INLA
integration strategy to "eb" to speed up calculations. This is normally not
needed since version 2.2.0, since the only the final iteration will use
other than "eb".

\item \code{fm_has_PROJ6()}: Detect whether PROJ6 is available

\item \code{fm_not_for_PROJ6()}: \code{fm_not_for_PROJ6} is called to warn about using old PROJ4
features even though PROJ6 is available

\item \code{fm_not_for_PROJ4()}: \code{fm_not_for_PROJ4} is called to give an error when
calling methods that are only available for PROJ6

\item \code{fm_fallback_PROJ6()}: Called to warn about falling back
to using old PROJ4 methods when a PROJ6 method hasn't been implemented

\item \code{fm_requires_PROJ6()}: Called to give an error when PROJ6
is required but not available

\item \code{fm_sp_get_crs()}: Wrapper for CRS(projargs) (PROJ4) and CRS(wkt) for
\code{sp::Spatial} objects.

\item \code{fm_spTransform()}: Handle transformation of various inla objects according to coordinate
reference systems of sp::CRS or INLA::inla.CRS class.

\item \code{fm_spTransform(default)}: The default method handles low level transformation of raw
coordinates.

\item \code{ibm_valid_input()}: Use case changed to \code{\link[=ibm_invalid_output]{ibm_invalid_output()}}

\item \code{ibm_amatrix(bru_mapper_inla_mesh_2d)}: Replaced by \code{\link[=ibm_jacobian]{ibm_jacobian()}}

\item \code{ibm_amatrix(bru_mapper_inla_mesh_1d)}: Replaced by \code{\link[=ibm_jacobian]{ibm_jacobian()}}

\item \code{ibm_amatrix(bru_mapper_index)}: Replaced by \code{\link[=ibm_jacobian]{ibm_jacobian()}}

\item \code{ibm_amatrix(bru_mapper_linear)}: Replaced by \code{\link[=ibm_jacobian]{ibm_jacobian()}}

\item \code{ibm_amatrix(bru_mapper_matrix)}: Replaced by \code{\link[=ibm_jacobian]{ibm_jacobian()}}

\item \code{ibm_amatrix(bru_mapper_factor)}: Replaced by \code{\link[=ibm_jacobian]{ibm_jacobian()}}

\item \code{bru_mapper_offset()}: Creates a \code{\link[=bru_mapper_const]{bru_mapper_const()}} mapper.

\item \code{ibm_n(bru_mapper_offset)}: Replaced by \link{bru_mapper_const} methods

\item \code{ibm_values(bru_mapper_offset)}: Replaced by \link{bru_mapper_const} methods

\item \code{ibm_amatrix(bru_mapper_offset)}: Replaced by \link{bru_mapper_const} methods

\item \code{ibm_amatrix(bru_mapper_multi)}: Replaced by \code{\link[=ibm_jacobian]{ibm_jacobian()}}

\item \code{ibm_amatrix(bru_mapper_collect)}: Replaced by \code{\link[=ibm_jacobian]{ibm_jacobian()}}

\item \code{vertices.inla.mesh()}: Extract vertex locations from an \code{inla.mesh}.
Converts the vertices of an \code{inla.mesh} object into a \code{SpatialPointsDataFrame}.
Deprecated in favour of \code{\link[=fm_vertices]{fm_vertices()}}

\item \code{eval_SpatialDF()}: Replaced by the generic \code{\link[=eval_spatial]{eval_spatial()}}

}}
\examples{
\dontrun{
# Note: Only run this if you want to change the inlabru options for this session

# Determine current bru defaults:
bo <- bru_options_get()

init.tutorial()

# Check if it worked:
bru_options_get("control.inla")
}

\dontrun{
if (interactive()) {
  s <- sp::SpatialPoints(matrix(1:6, 3, 2), proj4string = fm_CRS("sphere"))
  fm_sp_get_crs(s)
}
}
}
\seealso{
\code{\link[=fm_transform]{fm_transform()}}
}
\author{
Finn Lindgren \email{finn.lindgren@gmail.com}

Fabian E. Bachl \email{bachlfab@gmail.com}
}
