% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crs.R
\docType{data}
\name{crs}
\alias{crs}
\title{Coordinate Reference System}
\format{
A list with the following elements representing the CRS:
\code{input} is the \href{https://proj4.org/}{PROJ.4} string, and \code{wkt} is the WKT2 strings.
}
\source{
Idaho National Laboratory Project Office
}
\usage{
crs
}
\description{
Coordinate reference system (CRS) used by the
U.S. Geological Survey Idaho National Laboratory Project Office.
The CRS is based on the following attributes:
Albers equal-area conic projection;
latitude of first and second standard parallel is 42.83 and 44.16 decimal degrees, respectively;
latitude and longitude of false origin is 41.5 and -113 decimal degrees, respectively;
easting and northing of false origin is 200,000 and 0 meters, respectively;
Clarke (1966) reference ellipsoid; North American Datum of 1983; and units of meters.
The CRS is represented using an updated version of the well-known text
(\href{https://docs.ogc.org/is/18-010r7/18-010r7.html}{WKT2}) strings.
}
\examples{
print(crs)
}
\keyword{datasets}
