% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RmSmallCellChunks.R
\name{RmSmallCellChunks}
\alias{RmSmallCellChunks}
\title{Remove Small Cell Chunks}
\usage{
RmSmallCellChunks(r)
}
\arguments{
\item{r}{'RasterLayer'.
Raster grid layer with cell values.}
}
\value{
Returns an object of class 'RasterLayer' giving
  \code{r} with cell values in the smaller cell chunks set to \code{NA}.
}
\description{
Remove small cell chunks from a raster layer,
where a cell chunk is defined as a group of connected cells with non-missing values.
The cell chunk with the largest surface area is preserved and all others removed.
}
\examples{
set.seed(2)
r <- raster::raster(ncols = 10, nrows = 10)
r[] <- round(runif(raster::ncell(r)) * 0.7)
r <- raster::clump(r)
r <- raster::ratify(r)
PlotMap(r)

r_new <- RmSmallCellChunks(r)
PlotMap(r_new)

graphics.off()

}
\seealso{
\code{\link{clump}}
}
\author{
J.C. Fisher, U.S. Geological Survey, Idaho Water Science Center
}
\keyword{utilities}
